  org 100h  ; assume ax=bx=0 si=100h sp=-2
  
  db 0x3F,0xC1,122,7,0

;  mov al,13h
;  int 10h
;  push 0a000h
;  pop es

  mov fs,ax   ; timing

  mov cl,30   ; max polyphony = 32 (0 is already pushed)

  xor ebp,ebp ; cycle has 32 ticks: which ticks play a note
  mov al,18
Z bts ebp,ebx
  jnc K
  xor al,29^18; if there's a note on this tick, switch 18<->29
K add bx,ax   ; add +18 or +29
  push bx     ; store time
  loop Z

  mov dx,331h
  outsb       ; 3F: UART simple mode
  dec dx
  outsb       ; C1: Program change, channel 2
  outsb       ; 122: Seashore

  mov bx,256  ; initial song position = 256
M:
  mov al,[fs:0x46c]
  add al,4    ; wait 219.7 ms
W:cmp al,[fs:0x46c]
  jne W

; Play notes for the current tick.
  mov di,sp
T:mov ax,bx
  sub ax,[di]   ; should it play yet?
  and ax,801Fh  ; on this tick?
  mov al,' '
  jnz N

  mov al,90h  ; Note On, channel 1
  out dx,al

  imul ax,di,-6 ; 12 notes in octave
  add ax,32*7+5 ; first note is D
  div byte[si]  ; 7 notes in scale

  cmp al,36   ; lowest two notes: seashore sound
  out dx,al   ; note
  mov al,64   
  out dx,al   ; velocity 64
  ja Q

  mov al,91h  ; Note On, channel 2
  out dx,al
  mov al,48   ; note C4
  out dx,al
  out dx,al   ; velocity 48

Q: mov al,'*'
N: int 29h

  inc di
  inc di
  jnz T

  mov cl,49
F mov al,' '
  int 29h
  loop F

  inc bx

  in al,60h
  cmp al,1
  jnz M
  int 20h
